<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroyMenuMultumRequest;
use App\Http\Requests\StoreMenuMultumRequest;
use App\Http\Requests\UpdateMenuMultumRequest;
use App\Models\MenuMultum;
use App\Models\Meuscondutore;
use App\Models\Team;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class MenuMultasController extends Controller
{
    use CsvImportTrait;

    public function index(Request $request)
    {
        abort_if(Gate::denies('menu_multum_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = MenuMultum::with(['condutor', 'team'])->select(sprintf('%s.*', (new MenuMultum)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'menu_multum_show';
                $editGate      = 'menu_multum_edit';
                $deleteGate    = 'menu_multum_delete';
                $crudRoutePart = 'menu-multa';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('placa', function ($row) {
                return $row->placa ? $row->placa : '';
            });
            $table->editColumn('auto', function ($row) {
                return $row->auto ? $row->auto : '';
            });
            $table->editColumn('infracao', function ($row) {
                return $row->infracao ? $row->infracao : '';
            });
            $table->editColumn('orgao_competente', function ($row) {
                return $row->orgao_competente ? $row->orgao_competente : '';
            });
            $table->editColumn('local', function ($row) {
                return $row->local ? $row->local : '';
            });
            $table->addColumn('condutor_nome', function ($row) {
                return $row->condutor ? $row->condutor->nome : '';
            });

            $table->editColumn('situacao', function ($row) {
                return $row->situacao ? $row->situacao : '';
            });

            $table->editColumn('valor_total', function ($row) {
                return $row->valor_total ? $row->valor_total : '';
            });

            $table->editColumn('infracao_autoriazada', function ($row) {
                return $row->infracao_autoriazada ? MenuMultum::INFRACAO_AUTORIAZADA_SELECT[$row->infracao_autoriazada] : '';
            });
            $table->editColumn('pagamento_disponivel', function ($row) {
                return $row->pagamento_disponivel ? MenuMultum::PAGAMENTO_DISPONIVEL_SELECT[$row->pagamento_disponivel] : '';
            });
            $table->editColumn('statuspagamento', function ($row) {
                return $row->statuspagamento ? MenuMultum::STATUSPAGAMENTO_SELECT[$row->statuspagamento] : '';
            });
            $table->editColumn('gera_nic', function ($row) {
                return $row->gera_nic ? MenuMultum::GERA_NIC_SELECT[$row->gera_nic] : '';
            });
            $table->editColumn('auto_gerador', function ($row) {
                return $row->auto_gerador ? $row->auto_gerador : '';
            });

            $table->rawColumns(['actions', 'placeholder', 'condutor']);

            return $table->make(true);
        }

        $meuscondutores = Meuscondutore::get();
        $teams          = Team::get();

        return view('admin.menuMulta.index', compact('meuscondutores', 'teams'));
    }

    public function create()
    {
        abort_if(Gate::denies('menu_multum_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $condutors = Meuscondutore::pluck('nome', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.menuMulta.create', compact('condutors'));
    }

    public function store(StoreMenuMultumRequest $request)
    {
        $menuMultum = MenuMultum::create($request->all());

        return redirect()->route('admin.menu-multa.index');
    }

    public function edit(MenuMultum $menuMultum)
    {
        abort_if(Gate::denies('menu_multum_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $condutors = Meuscondutore::pluck('nome', 'id')->prepend(trans('global.pleaseSelect'), '');

        $menuMultum->load('condutor', 'team');

        return view('admin.menuMulta.edit', compact('condutors', 'menuMultum'));
    }

    public function update(UpdateMenuMultumRequest $request, MenuMultum $menuMultum)
    {
        $menuMultum->update($request->all());

        return redirect()->route('admin.menu-multa.index');
    }

    public function show(MenuMultum $menuMultum)
    {
        abort_if(Gate::denies('menu_multum_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $menuMultum->load('condutor', 'team');

        return view('admin.menuMulta.show', compact('menuMultum'));
    }

    public function destroy(MenuMultum $menuMultum)
    {
        abort_if(Gate::denies('menu_multum_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $menuMultum->delete();

        return back();
    }

    public function massDestroy(MassDestroyMenuMultumRequest $request)
    {
        $menuMulta = MenuMultum::find(request('ids'));

        foreach ($menuMulta as $menuMultum) {
            $menuMultum->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
