<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreMenuMultumRequest;
use App\Http\Requests\UpdateMenuMultumRequest;
use App\Http\Resources\Admin\MenuMultumResource;
use App\Models\MenuMultum;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class MenuMultasApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('menu_multum_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MenuMultumResource(MenuMultum::with(['condutor', 'team'])->get());
    }

    public function store(StoreMenuMultumRequest $request)
    {
        $menuMultum = MenuMultum::create($request->all());

        return (new MenuMultumResource($menuMultum))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(MenuMultum $menuMultum)
    {
        abort_if(Gate::denies('menu_multum_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MenuMultumResource($menuMultum->load(['condutor', 'team']));
    }

    public function update(UpdateMenuMultumRequest $request, MenuMultum $menuMultum)
    {
        $menuMultum->update($request->all());

        return (new MenuMultumResource($menuMultum))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(MenuMultum $menuMultum)
    {
        abort_if(Gate::denies('menu_multum_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $menuMultum->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
