<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreMeuscondutoreRequest;
use App\Http\Requests\UpdateMeuscondutoreRequest;
use App\Http\Resources\Admin\MeuscondutoreResource;
use App\Models\Meuscondutore;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class MeuscondutoresApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('meuscondutore_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MeuscondutoreResource(Meuscondutore::with(['team'])->get());
    }

    public function store(StoreMeuscondutoreRequest $request)
    {
        $meuscondutore = Meuscondutore::create($request->all());

        return (new MeuscondutoreResource($meuscondutore))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Meuscondutore $meuscondutore)
    {
        abort_if(Gate::denies('meuscondutore_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MeuscondutoreResource($meuscondutore->load(['team']));
    }

    public function update(UpdateMeuscondutoreRequest $request, Meuscondutore $meuscondutore)
    {
        $meuscondutore->update($request->all());

        return (new MeuscondutoreResource($meuscondutore))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Meuscondutore $meuscondutore)
    {
        abort_if(Gate::denies('meuscondutore_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meuscondutore->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
