<?php

namespace App\Http\Requests;

use App\Models\MenuMultum;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyMenuMultumRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('menu_multum_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:menu_multa,id',
        ];
    }
}
