<?php

namespace App\Http\Requests;

use App\Models\Meusveiculo;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateMeusveiculoRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('meusveiculo_edit');
    }

    public function rules()
    {
        return [
            'placa' => [
                'string',
                'required',
                'unique:meusveiculos,placa,' . request()->route('meusveiculo')->id,
            ],
            'renavam' => [
                'string',
                'required',
                'unique:meusveiculos,renavam,' . request()->route('meusveiculo')->id,
            ],
            'chassi' => [
                'string',
                'nullable',
            ],
            'marca_modelo' => [
                'string',
                'nullable',
            ],
            'cor' => [
                'string',
                'nullable',
            ],
            'anomodelo' => [
                'string',
                'nullable',
            ],
            'empresa' => [
                'string',
                'nullable',
            ],
            'cpfcnpj' => [
                'string',
                'nullable',
            ],
            'setor' => [
                'string',
                'nullable',
            ],
            'seguradora' => [
                'string',
                'nullable',
            ],
            'tag' => [
                'string',
                'nullable',
            ],
        ];
    }
}
