<?php

namespace App\Models;

use App\Traits\MultiTenantModelTrait;
use Carbon\Carbon;
use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuMultum extends Model
{
    use SoftDeletes, MultiTenantModelTrait, HasFactory;

    public $table = 'menu_multa';

    public const GERA_NIC_SELECT = [
        '1' => 'Não',
        '2' => 'Sim',
    ];

    public const INFRACAO_AUTORIAZADA_SELECT = [
        '1' => 'Não',
        '2' => 'Sim',
    ];

    public const PAGAMENTO_DISPONIVEL_SELECT = [
        '1' => 'Não',
        '2' => 'Sim',
    ];

    public const STATUSPAGAMENTO_SELECT = [
        '1' => 'Em aberto',
        '2' => 'Pago',
    ];

    protected $dates = [
        'data_infracao',
        'vencimento_auto',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'placa',
        'auto',
        'infracao',
        'orgao_competente',
        'local',
        'condutor_id',
        'situacao',
        'data_infracao',
        'valor_total',
        'vencimento_auto',
        'infracao_autoriazada',
        'pagamento_disponivel',
        'statuspagamento',
        'created_at',
        'gera_nic',
        'auto_gerador',
        'updated_at',
        'deleted_at',
        'team_id',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function condutor()
    {
        return $this->belongsTo(Meuscondutore::class, 'condutor_id');
    }

    public function getDataInfracaoAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('panel.date_format')) : null;
    }

    public function setDataInfracaoAttribute($value)
    {
        $this->attributes['data_infracao'] = $value ? Carbon::createFromFormat(config('panel.date_format'), $value)->format('Y-m-d') : null;
    }

    public function getVencimentoAutoAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('panel.date_format')) : null;
    }

    public function setVencimentoAutoAttribute($value)
    {
        $this->attributes['vencimento_auto'] = $value ? Carbon::createFromFormat(config('panel.date_format'), $value)->format('Y-m-d') : null;
    }

    public function team()
    {
        return $this->belongsTo(Team::class, 'team_id');
    }
}
