<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenuMultaTable extends Migration
{
    public function up()
    {
        Schema::create('menu_multa', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('placa');
            $table->string('auto')->unique();
            $table->string('infracao')->nullable();
            $table->string('orgao_competente')->nullable();
            $table->string('local')->nullable();
            $table->string('situacao');
            $table->date('data_infracao');
            $table->float('valor_total', 15, 2)->nullable();
            $table->date('vencimento_auto')->nullable();
            $table->string('infracao_autoriazada')->nullable();
            $table->string('pagamento_disponivel')->nullable();
            $table->string('statuspagamento')->nullable();
            $table->string('gera_nic')->nullable();
            $table->string('auto_gerador')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
