@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.debitosGerai.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.debitos-gerais.update", [$debitosGerai->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label for="placa">{{ trans('cruds.debitosGerai.fields.placa') }}</label>
                <input class="form-control {{ $errors->has('placa') ? 'is-invalid' : '' }}" type="text" name="placa" id="placa" value="{{ old('placa', $debitosGerai->placa) }}">
                @if($errors->has('placa'))
                    <span class="text-danger">{{ $errors->first('placa') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.placa_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="ipva">{{ trans('cruds.debitosGerai.fields.ipva') }}</label>
                <input class="form-control {{ $errors->has('ipva') ? 'is-invalid' : '' }}" type="number" name="ipva" id="ipva" value="{{ old('ipva', $debitosGerai->ipva) }}" step="0.01">
                @if($errors->has('ipva'))
                    <span class="text-danger">{{ $errors->first('ipva') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.ipva_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="taxa_de_licenciamento">{{ trans('cruds.debitosGerai.fields.taxa_de_licenciamento') }}</label>
                <input class="form-control {{ $errors->has('taxa_de_licenciamento') ? 'is-invalid' : '' }}" type="number" name="taxa_de_licenciamento" id="taxa_de_licenciamento" value="{{ old('taxa_de_licenciamento', $debitosGerai->taxa_de_licenciamento) }}" step="0.01">
                @if($errors->has('taxa_de_licenciamento'))
                    <span class="text-danger">{{ $errors->first('taxa_de_licenciamento') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.taxa_de_licenciamento_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="licenciamento_anteriores">{{ trans('cruds.debitosGerai.fields.licenciamento_anteriores') }}</label>
                <input class="form-control {{ $errors->has('licenciamento_anteriores') ? 'is-invalid' : '' }}" type="number" name="licenciamento_anteriores" id="licenciamento_anteriores" value="{{ old('licenciamento_anteriores', $debitosGerai->licenciamento_anteriores) }}" step="0.01">
                @if($errors->has('licenciamento_anteriores'))
                    <span class="text-danger">{{ $errors->first('licenciamento_anteriores') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.licenciamento_anteriores_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="multas">{{ trans('cruds.debitosGerai.fields.multas') }}</label>
                <input class="form-control {{ $errors->has('multas') ? 'is-invalid' : '' }}" type="number" name="multas" id="multas" value="{{ old('multas', $debitosGerai->multas) }}" step="0.01">
                @if($errors->has('multas'))
                    <span class="text-danger">{{ $errors->first('multas') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.multas_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="situacao">{{ trans('cruds.debitosGerai.fields.situacao') }}</label>
                <input class="form-control {{ $errors->has('situacao') ? 'is-invalid' : '' }}" type="text" name="situacao" id="situacao" value="{{ old('situacao', $debitosGerai->situacao) }}">
                @if($errors->has('situacao'))
                    <span class="text-danger">{{ $errors->first('situacao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.situacao_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="financiamento">{{ trans('cruds.debitosGerai.fields.financiamento') }}</label>
                <input class="form-control {{ $errors->has('financiamento') ? 'is-invalid' : '' }}" type="text" name="financiamento" id="financiamento" value="{{ old('financiamento', $debitosGerai->financiamento) }}">
                @if($errors->has('financiamento'))
                    <span class="text-danger">{{ $errors->first('financiamento') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.debitosGerai.fields.financiamento_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection