@extends('layouts.admin')
@section('content')
@can('menu_multum_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.menu-multa.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.menuMultum.title_singular') }}
            </a>
            <button class="btn btn-warning" data-toggle="modal" data-target="#csvImportModal">
                {{ trans('global.app_csvImport') }}
            </button>
            @include('csvImport.modal', ['model' => 'MenuMultum', 'route' => 'admin.menu-multa.parseCsvImport'])
        </div>
    </div>
@endcan
<div class="card">
    <div class="card-header">
        {{ trans('cruds.menuMultum.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <table class=" table table-bordered table-striped table-hover ajaxTable datatable datatable-MenuMultum">
            <thead>
                <tr>
                    <th width="10">

                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.placa') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.auto') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.infracao') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.orgao_competente') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.local') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.condutor') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.situacao') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.data_infracao') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.valor_total') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.vencimento_auto') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.infracao_autoriazada') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.pagamento_disponivel') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.statuspagamento') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.gera_nic') }}
                    </th>
                    <th>
                        {{ trans('cruds.menuMultum.fields.auto_gerador') }}
                    </th>
                    <th>
                        &nbsp;
                    </th>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                        <select class="search">
                            <option value>{{ trans('global.all') }}</option>
                            @foreach($meuscondutores as $key => $item)
                                <option value="{{ $item->nome }}">{{ $item->nome }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                    </td>
                    <td>
                        <select class="search" strict="true">
                            <option value>{{ trans('global.all') }}</option>
                            @foreach(App\Models\MenuMultum::INFRACAO_AUTORIAZADA_SELECT as $key => $item)
                                <option value="{{ $key }}">{{ $item }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <select class="search" strict="true">
                            <option value>{{ trans('global.all') }}</option>
                            @foreach(App\Models\MenuMultum::PAGAMENTO_DISPONIVEL_SELECT as $key => $item)
                                <option value="{{ $key }}">{{ $item }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <select class="search" strict="true">
                            <option value>{{ trans('global.all') }}</option>
                            @foreach(App\Models\MenuMultum::STATUSPAGAMENTO_SELECT as $key => $item)
                                <option value="{{ $key }}">{{ $item }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <select class="search" strict="true">
                            <option value>{{ trans('global.all') }}</option>
                            @foreach(App\Models\MenuMultum::GERA_NIC_SELECT as $key => $item)
                                <option value="{{ $key }}">{{ $item }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <input class="search" type="text" placeholder="{{ trans('global.search') }}">
                    </td>
                    <td>
                    </td>
                </tr>
            </thead>
        </table>
    </div>
</div>



@endsection
@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('menu_multum_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}';
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.menu-multa.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).data(), function (entry) {
          return entry.id
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  let dtOverrideGlobals = {
    buttons: dtButtons,
    processing: true,
    serverSide: true,
    retrieve: true,
    aaSorting: [],
    ajax: "{{ route('admin.menu-multa.index') }}",
    columns: [
      { data: 'placeholder', name: 'placeholder' },
{ data: 'placa', name: 'placa' },
{ data: 'auto', name: 'auto' },
{ data: 'infracao', name: 'infracao' },
{ data: 'orgao_competente', name: 'orgao_competente' },
{ data: 'local', name: 'local' },
{ data: 'condutor_nome', name: 'condutor.nome' },
{ data: 'situacao', name: 'situacao' },
{ data: 'data_infracao', name: 'data_infracao' },
{ data: 'valor_total', name: 'valor_total' },
{ data: 'vencimento_auto', name: 'vencimento_auto' },
{ data: 'infracao_autoriazada', name: 'infracao_autoriazada' },
{ data: 'pagamento_disponivel', name: 'pagamento_disponivel' },
{ data: 'statuspagamento', name: 'statuspagamento' },
{ data: 'gera_nic', name: 'gera_nic' },
{ data: 'auto_gerador', name: 'auto_gerador' },
{ data: 'actions', name: '{{ trans('global.actions') }}' }
    ],
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  };
  let table = $('.datatable-MenuMultum').DataTable(dtOverrideGlobals);
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
let visibleColumnsIndexes = null;
$('.datatable thead').on('input', '.search', function () {
      let strict = $(this).attr('strict') || false
      let value = strict && this.value ? "^" + this.value + "$" : this.value

      let index = $(this).parent().index()
      if (visibleColumnsIndexes !== null) {
        index = visibleColumnsIndexes[index]
      }

      table
        .column(index)
        .search(value, strict)
        .draw()
  });
table.on('column-visibility.dt', function(e, settings, column, state) {
      visibleColumnsIndexes = []
      table.columns(":visible").every(function(colIdx) {
          visibleColumnsIndexes.push(colIdx);
      });
  })
});

</script>
@endsection