@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.meuscondutore.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.meuscondutores.update", [$meuscondutore->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="nome">{{ trans('cruds.meuscondutore.fields.nome') }}</label>
                <input class="form-control {{ $errors->has('nome') ? 'is-invalid' : '' }}" type="text" name="nome" id="nome" value="{{ old('nome', $meuscondutore->nome) }}" required>
                @if($errors->has('nome'))
                    <span class="text-danger">{{ $errors->first('nome') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meuscondutore.fields.nome_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="numregistro">{{ trans('cruds.meuscondutore.fields.numregistro') }}</label>
                <input class="form-control {{ $errors->has('numregistro') ? 'is-invalid' : '' }}" type="text" name="numregistro" id="numregistro" value="{{ old('numregistro', $meuscondutore->numregistro) }}" required>
                @if($errors->has('numregistro'))
                    <span class="text-danger">{{ $errors->first('numregistro') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meuscondutore.fields.numregistro_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required">{{ trans('cruds.meuscondutore.fields.uf') }}</label>
                <select class="form-control {{ $errors->has('uf') ? 'is-invalid' : '' }}" name="uf" id="uf" required>
                    <option value disabled {{ old('uf', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\Meuscondutore::UF_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('uf', $meuscondutore->uf) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('uf'))
                    <span class="text-danger">{{ $errors->first('uf') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meuscondutore.fields.uf_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="validade">{{ trans('cruds.meuscondutore.fields.validade') }}</label>
                <input class="form-control date {{ $errors->has('validade') ? 'is-invalid' : '' }}" type="text" name="validade" id="validade" value="{{ old('validade', $meuscondutore->validade) }}">
                @if($errors->has('validade'))
                    <span class="text-danger">{{ $errors->first('validade') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meuscondutore.fields.validade_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="categoria">{{ trans('cruds.meuscondutore.fields.categoria') }}</label>
                <input class="form-control {{ $errors->has('categoria') ? 'is-invalid' : '' }}" type="text" name="categoria" id="categoria" value="{{ old('categoria', $meuscondutore->categoria) }}">
                @if($errors->has('categoria'))
                    <span class="text-danger">{{ $errors->first('categoria') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meuscondutore.fields.categoria_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required">{{ trans('cruds.meuscondutore.fields.status') }}</label>
                <select class="form-control {{ $errors->has('status') ? 'is-invalid' : '' }}" name="status" id="status" required>
                    <option value disabled {{ old('status', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\Meuscondutore::STATUS_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('status', $meuscondutore->status) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('status'))
                    <span class="text-danger">{{ $errors->first('status') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meuscondutore.fields.status_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection