@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.meuscondutore.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.meuscondutores.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.meuscondutore.fields.nome') }}
                        </th>
                        <td>
                            {{ $meuscondutore->nome }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meuscondutore.fields.numregistro') }}
                        </th>
                        <td>
                            {{ $meuscondutore->numregistro }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meuscondutore.fields.uf') }}
                        </th>
                        <td>
                            {{ App\Models\Meuscondutore::UF_SELECT[$meuscondutore->uf] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meuscondutore.fields.validade') }}
                        </th>
                        <td>
                            {{ $meuscondutore->validade }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meuscondutore.fields.categoria') }}
                        </th>
                        <td>
                            {{ $meuscondutore->categoria }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meuscondutore.fields.status') }}
                        </th>
                        <td>
                            {{ App\Models\Meuscondutore::STATUS_SELECT[$meuscondutore->status] ?? '' }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.meuscondutores.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection